###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_code_exec_vuln_jul09_win.nasl 3622 2009-07-23 14:12:33Z jul $
#
# Mozilla Firefox Remote Code Execution Vulnerabilities July-09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900398);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2467");
  script_bugtraq_id(35767);
  script_name("Mozilla Firefox Remote Code Execution Vulnerabilities July-09 (Win)");
  desc = "

  Overview: The host is installed with Firefox browser and is prone to Remote
  Code Execution vulnerabilities.

  Vulnerability Insight:
  Error exists when a page contains a Flash object which presents a slow script
  dialog, and the page is navigated while the dialog is still visible to the
  user, the Flash plugin is unloaded resulting in a crash due to a call to the
  deleted object.

  Impact:
  Successful exploitation could allow remote attacker to execute arbitrary code
  and results in Denial of Service condition.

  Impact Level:System/Application

  Affected Software/OS:
  Mozilla Firefox version prior to 3.0.12 and 3.5.1 on Windows.

  Fix: Upgrade to Firefox version 3.0.12 or 3.5.1 or later
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/35914
  http://www.vupen.com/english/advisories/2009/1972
  http://www.mozilla.org/security/announce/2009/mfsa2009-35.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version < 3.0.12 and < 3.5.1
if(version_is_less(version:ffVer, test_version:"3.0.12") ||
   version_is_equal(version:ffVer, test_version:"3.5")){
   security_hole(0);
}
