###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_pdf_js_rest_bypass_vuln_lin.nasl 2242 2009-05-15 17:30:33Z may $
#
# Mozilla Firefox PDF Javascript Restriction Bypass Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900351);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1597");
  script_name("Mozilla Firefox PDF JavaScript Restriction Bypass Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone to
  PDF Javascript Restriction Bypass Vulnerability.

  Vulnerability Insight:
  Error while executing DOM calls in response to a javascript: URI in the target
  attribute of a submit element within a form contained in an inline PDF file
  which causes bypassing restricted Adobe's JavaScript restrictions.

  Impact:
  Successful exploitation will let attacker execute arbitrary codes in the
  context of the malicious PDF file and execute arbitrary codes into the context
  of the remote system.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.0.10 and prior on Linux.

  Fix: No solution or patch is available as on 18th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/index.html

  References:
  http://www.securityfocus.com/archive/1/archive/1/503183/100/0/threaded
  http://secniche.org/papers/SNS_09_03_PDF_Silent_Form_Re_Purp_Attack.pdf

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(ffVer == NULL){
  exit(0);
}

# Grep for Firefox version <= 3.0.10
if(version_is_less_equal(version:ffVer, test_version:"3.0.10")){
  security_hole(0);
}
