###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_foxit_reader_mult_dos_vuln_jun09.nasl 3102 2009-06-24 17:15:33Z jun $
#
# Foxit Reader Multiple Denial of Service Vulnerabilities - Jun09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900683);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-0690 ", "CVE-2009-0691");
  script_bugtraq_id(35442, 35443);
  script_name("Foxit Reader Multiple Denial of Service Vulnerabilities - Jun09");
  desc = "

  Overview: The host is installed with Foxit Reader and is prone to
  multiple Denial of Service vulnerabilities.

  Vulnerability Insight:
  Multiple errors exist in the Foxit JPEG2000/JBIG2 Decoder add-on.
  - An error occures while processing a negative value for the stream offset
    in a JPX stream.
  - A fatal error while decoding JPX header which results in a subsequent
    invalid address access.

  Impact:
  Successful exploitation will let attacker execute arbitrary code or crash an
  affected application.

  Impact Level: Application

  Affected Software/OS:
  Foxit Reader 3.0 before Build 1817 and JPEG2000/JBIG2 Decoder
  before 2.0.2009.616.

  Fix: Upgrade to the latest version.
  http://www.foxitsoftware.com/downloads/

  References:
  http://secunia.com/advisories/35512
  http://www.vupen.com/english/advisories/2009/1640
  http://www.foxitsoftware.com/pdf/reader/security.htm#0602

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Foxit Reader, fxdecod1.dll");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_foxit_reader_detect.nasl");
  script_require_keys("Foxit/Reader/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

foxVer = get_kb_item("Foxit/Reader/Ver");

if(version_in_range(version:foxVer,test_version:"3.0" ,test_version2:"3.0.2009.1817"))
{
  foxitPath = registry_get_sz(key:"SOFTWARE\Foxit Software\Foxit Reader",
                                 item:"InstallPath");
  if(foxitPath)
  {
    foxitPath = foxitPath + "fxdecod1.dll";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:foxitPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:foxitPath);
    fxdecodVer = GetVer(share:share, file:file);
    if((fxdecodVer) &&
      (version_is_less(version:fxdecodVer,test_version:"2.0.2009.616"))){
      security_hole(0);
    }
  }
}
