###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_freeradius_detect.nasl 4617 2009-09-22 21:25:29Z sep $
#
# FreeRADIUS Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900855);
  script_version("$Revision: 1.0 $");
  script_name("FreeRADIUS Version Detection");
  desc = "
  Overview: This script detects the installed version of FreeRADIUS and
  sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of FreeRADIUS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

radius_sock = ssh_login_or_reuse_connection();
if(!radius_sock){
  exit(0);
}

foreach name (make_list("radiusd", "freeradius"))
{
  radius_name = find_bin(prog_name:name, sock:radius_sock);
  foreach binName (radius_name)
  {
    radius_ver = get_bin_version(full_prog_name:chomp(binName),sock:radius_sock,
                                 version_argv:"-v", ver_pattern:"FreeRADIUS " +
                                 "Version ([0-9]\.[0-9.]+)");
     if(radius_ver[1] != NULL){
      set_kb_item(name:"FreeRADIUS/Ver", value:radius_ver[1]);
    }
  }
}
ssh_close_connection();
