##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_frontaccounting_detect.nasl 5847 2009-11-26 14:00:24Z nov $
#
# FrontAccounting Version Detection
#
# Authors:
# Maneesh KB <kmaneesh@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
  script_id(900256);
  script_version("$Revision: 1.0 $");
  script_name("FrontAccounting Detection");
  desc = "
  Overview: This script detects the installed version of FrontAccounting and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of FrontAccounting");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencie("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

foreach dir (make_list("/frontaccount", "/account", "/", cgi_dirs()))
{
  req = http_get(item:string(dir, "/index.php"), port:port);
  buf = http_send_recv(port:port, data:req, bodyonly:TRUE);

  if("FrontAccounting" >!< buf)
  {
    req = string("GET ", dir, "/index.php", "\r\n",
                 "Host: ", get_host_name(), "\r\n\r\n");
    buf = http_send_recv(port:port, data:req, bodyonly:FALSE);
  }

  # Grep version
  version = eregmatch(pattern:"(FrontAccounting |Version )([0-9.]+) ?([a-zA-Z]+ ?[0-9]+?)?",
                      string:buf, icase:TRUE);

  if(!isnull(version[2]))
  {
    if(version[3])
    {
      version[3] = ereg_replace(string: version[3], pattern:" ", replace:"");
      version = version[2] + "." + version[3];
    }
    else{
      version = version[2];
    }
    if(version)
    {
      set_kb_item(name:string("www/", port, "/FrontAccounting"),
                  value:string(version," under ",dir));
    }
  }
}
