###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_geoserver_detect.nasl 4769 2009-09-18 10:53:18Z sep $
#
# GeoServer Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900945);
  script_version("$Revision: 1.0 $");
  script_name("GeoServer Version Detection");
  desc = "
  Overview: This script detects the installed version of GeoServer
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the KB for the version of GeoServer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");

geoPort = get_http_port(default:8080);
if(!geoPort){
  geoPort = 8080;
}

if(!get_port_state(geoPort)){
  exit(0);
}

foreach dir (make_list("/", "/geoserver", cgi_dirs()))
{
  foreach path (make_list("/welcome.do", "/web/?wicket:bookmarkablePage=" +
                          ":org.geoserver.web.AboutGeoServerPage"))
  {
    sndReq = http_get(item:string(dir, path), port:geoPort);
    rcvRes = http_send_recv(port:geoPort, data:sndReq);

    if(("GeoServer" >< rcvRes) && egrep(pattern:"^HTTP/.* 200 OK",string:rcvRes))
    {
      geoVer = eregmatch(pattern:"GeoServer ([0-9.]+).?([a-zA-Z]+[0-9]"+
                                 "( [a-zA-Z]+)?)", string:rcvRes);
      if(geoVer[1] != NULL)
      {
        if(geoVer[2] != NULL)
        {
          geoVer[2] = ereg_replace(pattern:string(" "), replace:string("."),
                                 string:geoVer[2]);
          geoVer = geoVer[1] + "." + geoVer[2];
        }
        else
          geoVer = geoVer[1];
      }
      else
      {
        geoVer = eregmatch(pattern:"GeoServer ([0-9.]+)", string:rcvRes);
        if(geoVer[1] != NULL){
          geoVer = geoVer[1];
        }
      }
      if(geoVer)
      {
        set_kb_item(name:"www/" + geoPort + "/GeoServer",
                    value:geoVer + " under " + dir);
      }
    }
  }
}
