###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_tooltip_manager_dos_vuln.nasl 4262 2009-08-26 09:40:29Z aug $
#
# Google Chrome 'tooltip_manager.cc' Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900825);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7061");
  script_bugtraq_id(30975);
  script_name("Google Chrome 'tooltip_manager.cc' Denial Of Service Vulnerability");
  desc = "

  Overview: This host is installed with Google Chrome and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  Error occurs in tooltip manager in chrome/views/tooltip_manager.cc caused
  via a tag with a long title attribute, which is not properly handled
  when displaying a tooltip.

  Impact:
  Successful exploitation lets the attacker cause memory or CPU consumption,
  resulting in Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version prior to 0.2.149.30 on Windows.

  Fix: Upgrade to version 0.2.149.30 or later
  http://www.google.com/chrome

  References:
  http://xforce.iss.net/xforce/xfdb/45039
  http://www.securityfocus.com/archive/1/496151/100/0/threaded
  http://www.securityfocus.com/archive/1/archive/1/496172/100/100/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version < 0.2.149.30
if(version_is_less(version:chromeVer, test_version:"0.2.149.30")){
  security_warning(0);
}
