#############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hamster_audio_player_detect.nasl 3579 2009-07-09 14:30:24Z jul $
#
# Hamster Audio Player Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800692);
  script_version("$ Revision: 1.0 $");
  script_name("Hamster Audio Player Version Detection");
  desc = "
  
  Overview : This script finds the installed OpenSSL version and saves the
  result in KB item.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of Hamster Audio player in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_keys(139,445); 
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  hamsterName = registry_get_sz(key:key + item, item:"DisplayName");
  
  if("Hamster" >< hamsterName)
  {
    hamsterVer = eregmatch(pattern:"Hamster ([0-9.]+([a-z]+)?)",
                                             string:hamsterName);
    if(hamsterVer[1] != NULL)
    {
      set_kb_item(name:"Hamster/Audio-Player/Ver", value:hamsterVer[1]);
      exit(0);
    }
  }
}
