##############################################################################
#
#  HP OpenView Network Node Manager Denial of Service Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/05
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0167
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900211);
 script_bugtraq_id(30984);
 script_cve_id("CVE-2008-3536", "CVE-2008-3537");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("HP OpenView Network Node Manager Denial of Service Vulnerabilities");
 script_summary("Check for version of HP OpenView Network Node Manager");
 desc = "
 Overview : This host is running HP OpenView Network Node Manager, which is
 prone to Denial of Service vulnerabilities.

 Vulnerability Insight :

        Flaws are caused due to errors in ovalarmsrv program.

        Impact : Successful exploitation can cause application to crash.

 Impact Level : Application

 Affected Software/OS :
        HP OpenView Network Node Manager (OV NNM) v7.01, v7.51, v7.53.

 Fix : Apply patches from,
 http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c01537275 

 *****
 NOTE : Ignore this warning, if above mentioned patch is already applied.
 *****

 References : http://secunia.com/advisories/31688/
 http://www.frsirt.com/english/advisories/2008/2485
 http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c01537275 

 CVSS Score :
        CVSS Base Score     : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.8
 Risk factor : High";

 script_description(desc);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 nnmPort = 7510;
 if(get_port_state(nnmPort))
 {
        nnmReq = http_get(item:"/topology/home", port:nnmPort);
        nnmRes = http_keepalive_send_recv(port:nnmPort, data:nnmReq);

        if("Network Node Manager Home Base" >< nnmRes &&
           egrep(pattern:"Copyright \(c\).* Hewlett-Packard", string:nnmRes) &&
           ereg(pattern:"^HTTP/.* 200 OK", string:nnmRes))
        {
        	if(egrep(pattern:"NNM Release B\.07\.(01|51|53)[^0-9]",
                         string:nnmRes)){
                        security_hole(nnmPort);
                }
                exit(0);
         }
 }
