###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hp_smh_detect.nasl 2395 2009-06-01 10:58:24Z may $
#
# HP System Management Homepage (SMH) Version Detection
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900657);
  script_version("Revision: 1.0 ");
  script_name("HP System Management Homepage (SMH) Version Detection");
  desc = "
  Overview: This script detects the installed version of HP System Management
  Homepage and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of HP SMH");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  exit(0);
}


include("http_func.inc");
include("misc_func.inc");

ports = add_port_in_list(list:get_kb_list("Services/www"), port:2301);
foreach port (ports)
{
  banner = get_http_banner(port:port);
  if("HP System Management Homepage" >< banner)
  {
    smhVer = eregmatch(pattern:"Homepage/([0-9.]+)" , string:banner);
    if(smhVer[1] != NULL)
    {
      set_kb_item(name:"www/" + port + "/HP/SMH", value:smhVer[1]);
      exit(0);
    }
  }
}
