##############################################################################
#
#  HP System Management Homepage Unspecified XSS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/14
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0315
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900150);
  script_bugtraq_id(31663);
  script_cve_id("CVE-2008-4411");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_name("HP System Management Homepage Unspecified XSS Vulnerability");
  script_summary("Check for vulnerable version of HP SMH");
  desc = "
  Overview : The host is running HP System Management Homepage, which is prone
  to unspecified XSS Vulnerability. 

  Certain input parameters are not properly sanitized before returned to the
  user.

  Impact:
  An attacker can execute arbitrary script code in the user's browser session.

  Impact Level : Application

  Affected Software/OS:
  HP System Management Homepage versions prior to 2.1.15.210

  Fix : Update to version 2.1.15.210 or later.
  HP System Management Homepage for Linux (x86) v2.1.15.210:
  http://h20000.www2.hp.com/bizsupport/TechSupport/SoftwareDescription.jsp?swItem=MTX-e85a4029b2dd42959f1f82dda7

  HP System Management Homepage for Linux (AMD64/EM64T) v2.1.15.210:
  http://h20000.www2.hp.com/bizsupport/TechSupport/SoftwareDescription.jsp?swItem=MTX-5c90113499bb41faacdcad9485  

  HP System Management Homepage for Windows v2.1.15.210:
  http://h20000.www2.hp.com/bizsupport/TechSupport/SoftwareDescription.jsp?swItem=MTX-84b4161b7cd3455fb34ac57586

  References :
  http://secunia.com/advisories/32199/
  http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c01570589

  CVSS Score :
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.7
  Risk factor : Medium";

  script_description(desc);
  script_dependencies("http_version.nasl");
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

smhPort = 2301;
if(get_port_state(smhPort))
{
  smhReq = http_get(item:"/", port:smhPort);
  smhRes = http_keepalive_send_recv(port:smhPort, data:smhReq);

  if(egrep(pattern:"CompaqHTTPServer/9\.9 HP System Management Homepage", 
     string:smhRes) && egrep(pattern:"^HTTP/.* 302 Found", string:smhRes))
  {
    if(egrep(pattern:"/2\.(0(\..*)?|1((\.[0-9]|\.1[0-5])(\.[01]?[0-9]?[0-9]|" +
                     "\.20[0-9])?)?)($|[^.0-9])", string:smhRes)){
       security_warning(smhPort);
    }
  }
}
