#############################################################################
#
#  IBM DB2 Server Detection (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Modified by: Veerendra GG (veerendragg@secpod.com) #6252
#  Date: 21st Dec 2009
#
#  Revision: 1.2
#
#  Log: veerendragg
#  Issue #0187
#
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900217);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 6243 $: 1.2");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("IBM DB2 Server Detection (Linux)");
 script_summary("Set KB for IBM DB2 Server");
 desc = "
 This script detects the version of IBM DB2 Server and saves the
 results in KB.

 Risk factor : Informational";

 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 sock = ssh_login_or_reuse_connection();
 if(sock)
 {
        db2Ver = ssh_cmd(socket:sock, cmd:"db2ls -a", timeout:120);
	ssh_close_connection();
        if(!db2Ver){
		exit(0);
	}

	ibmdbVer = eregmatch(pattern:" [.0-9]+", string:strstr(db2Ver, '/'));
	if(ibmdbVer != NULL)
	{
		set_kb_item(name:"Linux/IBM_db2/Ver", value:ibmdbVer[0]- " ");

		patchVer = eregmatch(pattern:" [.0-9a-z ]+",
				     string:strstr(db2Ver, '/'));

                patchVersion = ereg_replace(pattern:" +[.0-9]+ +([0-9a-z]+).*",
                                            replace:"\1", string:patchVer[0]);
		if(patchVersion != NULL){
			set_kb_item(name:"Linux/IBM_db2/FixPack", value:patchVersion);
		}
	}
 }
