##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_imagemagick_detect_lin.nasl 2507 2009-06-01 16:55:37Z may $
#
# ImageMagick Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900563);
  script_version("$Revision: 1.1 $");
  script_name("ImageMagick version Detection (Linux)");
  desc = "

  Overview : This script retrieves ImageMagick version and saves the
  result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set Version of ImageMagick in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"identify", sock:sock);
foreach binaryFile (getPath)
{
  imageVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-version",
                          ver_pattern:"ImageMagick ([0-9.]+\-?[0-9]?)", sock:sock);

  if(imageVer[1] != NULL)
  {
    imageVer[1] = ereg_replace(pattern:"-", string:imageVer[1], replace: ".");
    set_kb_item(name:"ImageMagick/Lin/Ver", value:imageVer[1]);
  }
}
ssh_close_connection();
