###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_isc_dhcp_client_detect.nasl 3518 2009-07-22 15:21:24Z jul $
#
# ISC DHCP Client Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900696);
  script_version("Revision: 1.0");
  script_name("ISC DHCP Client Version Detection");
  desc  = "

  Overview: This script detects the installed version of ISC DHCP Client
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of DHCP Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

dhcp_sock = ssh_login_or_reuse_connection();
if(!dhcp_sock){
  exit(0);
}

paths = find_bin(prog_name:"dhclient", sock:dhcp_sock);
foreach dhcpBin (paths)
{
   dhcpVer= get_bin_version(full_prog_name:chomp(dhcpBin),
            sock:dhcp_sock, version_argv:"--version",
            ver_pattern:"([0-9.]+)(-| )?((alpha|beta|rc|[a-z][0-9])?([0-9]+)?)");

   if(("isc-dhclient" >< dhcpVer) && (dhcpVer[1] != NULL))
   {
     if(dhcpVer[3] != NULL){
       dhcpVer = dhcpVer[1] + "." + dhcpVer[3];
     }
     else
       dhcpVer = dhcpVer[1];
   
     set_kb_item(name:"ISC/DHCP-Client/Ver", value:dhcpVer);
  }
}
ssh_close_connection();
