###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_kde_konqueror_detect.nasl 3567 2009-07-30 09:45:29Z jul $
#
# KDE Konqueror Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900902);
  script_version("$Revision: 1.0$");
  script_name("KDE Konqueror Version Detection");
  desc = "

  Overview:  This script finds the installed version of KDE
  Konqueror and saves the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of Konqueror in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

konqerName = find_file(file_name:"konqueror", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach binaryName (konqerName)
{
  binaryName = chomp(binaryName);
  konqerVer = get_bin_version(full_prog_name:binaryName, version_argv:"-v",
                 ver_pattern:"Konqueror: ([0-9.]+).?((rc|RC)?[0-9]+)?", sock:sock);

  if(konqerVer[1] != NULL)
  {
    if(konqerVer[2] != NULL){
       konqerVer = konqerVer[1] + "." + konqerVer[2];
     }
    else
      konqerVer = konqerVer[1];

    set_kb_item(name:"KDE/Konqueror/Ver", value:konqerVer);
  }
}
ssh_close_connection();
