###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_labtam_proftp_welcome_bof_vuln.nasl 5818 2009-11-19 16:06:48Z nov $
#
# Labtam ProFTP Welcome Message Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900980);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-3976");
  script_bugtraq_id(36128);
  script_name("Labtam ProFTP Welcome Message Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with Labtam ProFTP and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  A boundary error occurs when processing overly long welcome message sent by
  a FTP server.

  Impact:
  Attackers can exploit this issue by executing arbitrary code by tricking a
  user into connecting to a malicious FTP server and to crash an application.

  Impact Level: Application

  Affected Software/OS:
  Labtam ProFTP version 2.9 and prior on Windows.

  Fix:  No solution or patch is available as on 19th November,2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.labtam-inc.com/index.php

  References:
  http://secunia.com/advisories/36446/
  http://www.milw0rm.com/exploits/9508
  http://www.vupen.com/english/advisories/2009/2414

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Labtam ProFTP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_labtam_proftp_detect.nasl");
  script_require_keys("Labtam/ProFTP/Ver");
  exit(0);
}


include("version_func.inc");

pfVer = get_kb_item("Labtam/ProFTP/Ver");
if(!pfVer){
  exit(0);
}

if(version_is_less_equal(version:pfVer, test_version:"2.9")){
  security_warning(0);
}
