###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mozilla_prdts_info_disc_vuln_lin.nasl 4015 2009-08-18 11:39:33Z aug $
#
# Mozilla Products Information Disclosure Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900911);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6961");
  script_bugtraq_id(32363);
  script_name("Mozilla Products Information Disclosure Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Thunderbird/Seamonkey and is prone to
  Information Disclosure vulnerability.

  Vulnerability Insight:
  A flaw exists in the JavaScript code embedded in mailnews which can be
  exploited using scripts which read the '.documentURI' or '.textContent'
  DOM properties.

  Impact:
  Successful exploitation will let the attackes obtain the mailbox URI of the
  recipient or disclose comments placed in a forwarded email.

  Impact Level: Application

  Affected Software/OS:
  Seamonkey version prior to 1.1.13 and
  Thunderbird version prior to 2.0.0.18 on Linux.

  Fix:
  Upgrade to Seamonkey version 1.1.13 or later
  http://www.seamonkey-project.org/releases
  Upgrade to Thunderbird version 2.0.0.18 or later
  http://www.mozillamessaging.com/en-US/thunderbird/all.html

  References:
  http://secunia.com/advisories/32714
  http://secunia.com/advisories/32715
  http://xforce.iss.net/xforce/xfdb/46734
  http://www.mozilla.org/security/announce/2008/mfsa2008-59.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Thunderbird/Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_seamonkey_detect_lin.nasl",
                      "gb_thunderbird_detect_lin.nasl");
  script_require_keys("Seamonkey/Linux/Ver", "Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Linux/Ver");

if(smVer != NULL)
{
  # Grep for Seamonkey version prior to 1.1.13
  if(version_is_less(version:smVer, test_version:"1.1.13")){
    security_warning(0);
    exit(0);
  }
}

# Thunderbird Check
tbVer = get_kb_item("Thunderbird/Linux/Ver");

if(tbVer != NULL)
{
  # Grep for Thunderbird version prior to 2.0.0.18
  if(version_is_less(version:tbVer, test_version:"2.0.0.18")){
    security_warning(0);
  }
}
