###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-025.nasl 2775 2009-06-10 09:14:35Z jun $
#
# Vulnerabilities in Windows Kernel Could Allow Elevation of Privilege (968537)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900669);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1123","CVE-2009-1124","CVE-2009-1125", "CVE-2009-1126");
  script_bugtraq_id(35121, 35238, 35240,35120);
  script_name("Vulnerabilities in Windows Kernel Could Allow Elevation of Privilege (968537)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-025.

  Vulnerability Insight:
  Several flaws arise as the Windows kernel does not properly validate changes
  in certain kernel objects, pointers/input passed from user mode, arguments
  passed to system calls when editing a specific desktop parameter.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code with
  elevated privileges.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-025.mspx

  References:
  http://www.vupen.com/english/advisories/2009/1544
  http://www.microsoft.com/technet/security/bulletin/ms09-025.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check Hotfix Missing  (MS09-025)
if(hotfix_missing(name:"968537") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Win32k.sys");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Win32k.sys version < 5.0.2195.7279
    if(version_is_less(version:sysVer, test_version:"5.0.2195.7279")){
      security_hole(0);
  }
  exit(0);
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.3556
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3556")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.5796
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5796")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys version < 5.2.3790.4497
     if(version_is_less(version:sysVer, test_version:"5.2.3790.4497")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
