###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-037.nasl 3929 2009-08-14 09:14:35Z aug $
#
# Vulnerabilities in Microsoft ATL Could Allow Remote Code Execution (973908)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(101100);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-0015", "CVE-2008-002", "CVE-2009-0901",
                "CVE-2009-2493", "CVE-2009-2494");
  script_bugtraq_id(35558, 35585, 35832, 35828, 35982);
  script_name("Vulnerabilities in Microsoft ATL Could Allow Remote Code Execution (973908)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-037.

  Vulnerability Insight:
  The multiple flaws are due to:
  - Bug in the ATL header that could allow reading a variant from a stream and
    leaving the variant type read with an invalid variant. When deleting the
    variant, it is possible to free unintended areas in memory that could be
    controlled by an attacker.
  - Error in 'CComVariant::ReadFromStream()' function used in the ATL header.
    This function does not properly restrict untrusted data read from a stream.
  - An bug in the ATL headers that could allow an attacker to force VariantClear
    to be called on a VARIANT that has not been correctly initialized.
  - Bugs in the ATL headers that handle instantiation of an object from data
    streams.

  Impact:
  Successful exploitation could allow remote attacker execute arbitrary code on
  the vulnerable system.

  Impact Level: System

  Affected Software/OS:
  Windows Media Player 9/10/11
  Microsoft Outlook Express 6 Service Pack 1
  Microsoft Outlook Express 5.5 Service Pack 2
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-037.mspx

  References:
  http://secunia.com/advisories/36187
  http://support.microsoft.com/kb/973908
  http://www.vupen.com/english/advisories/2009/2232
  http://www.microsoft.com/technet/security/bulletin/ms09-037.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");


if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# MS09-037 Missing Hotfix
if((hotfix_missing(name:"973507") == 0)||(hotfix_missing(name:"973540") == 0)||
   (hotfix_missing(name:"973354") == 0)||(hotfix_missing(name:"973869") == 0)||
   (hotfix_missing(name:"973815") == 0)){
  exit(0);
}

# For Windows ATL Component
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");

if(sysPath != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                       string:sysPath + "\atl.dll");
  sysVer = GetVer(file:file, share:share);

  if(sysVer != NULL)
  {
    # Windows 2K
    if(hotfix_check_sp(win2k:5) > 0)
    {
      # Grep for atl.dll version < 3.0.9793.0
      if(version_is_less(version:sysVer, test_version:"3.0.9793.0")){
        security_hole(0);
      }
      exit(0);
    }
  }
  # Windows XP
  if(hotfix_check_sp(xp:4) > 0)
  {
    SP = get_kb_item("SMB/WinXP/ServicePack");
    if(("Service Pack 2" >< SP) || ("Service Pack 3" >< SP))
    {
      # Grep for atl.dll < 3.5.2284.2
      if(version_is_less(version:sysVer, test_version:"3.5.2284.2")){
        security_hole(0);
      }
      exit(0);
    }
    security_hole(0);
  }
  # Windows 2003
  if(hotfix_check_sp(win2003:3) > 0)
  {
    SP = get_kb_item("SMB/Win2003/ServicePack");
    if("Service Pack 2" >< SP)
    {
      # Grep for atl.dll version < 3.5.2284.2
      if(version_is_less(version:sysVer, test_version:"3.5.2284.2")){
        security_hole(0);
      }
      exit(0);
    }
    security_hole(0);
  }
}

# Check Hotfix Missing Media player
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(sysPath != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                       string:sysPath + "\wmp.dll");
  sysVer = GetVer(file:file, share:share);

  if(sysVer != NULL)
  {
    # Windows 2K
    if(hotfix_check_sp(win2k:5) > 0)
    {
      # Grep for wmp.dll version < 9.0.0.3364
      if(version_is_less(version:sysVer, test_version:"9.0.0.3364")){
        security_hole(0);
      }
      exit(0);
    }
    # Windows XP
    if(hotfix_check_sp(xp:4) > 0)
    {
      SP = get_kb_item("SMB/WinXP/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for wmp.dll 9.0 < 9.0.0.3271, 10.0 < 10.0.0.4006 and 11 < 11.0.5721.5268
        if(version_in_range(version:sysVer, test_version:"9.0", test_version2:"9.0.0.3270")||
           version_in_range(version:sysVer, test_version:"10.0", test_version2:"10.0.0.4005")||
           version_in_range(version:sysVer, test_version:"11.0", test_version2:"11.0.5721.5267")){
          security_hole(0);
        }
        exit(0);
      }
      if("Service Pack 3" >< SP)
      {
        # Grep for wmp.dll < 9.0.0.4507
        if(version_is_less(version:sysVer, test_version:"9.0.0.4507")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
    # Windows 2003
    if(hotfix_check_sp(win2003:3) > 0)
    {
      SP = get_kb_item("SMB/Win2003/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for wmp.dll version < 10.0.0.4006
        if(version_is_less(version:sysVer, test_version:"10.0.0.4006")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
  }
}

# Microsoft Outlook Express 5.5 Service Pack 2 or 6 Service Pack 1
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                         item:"ProgramFilesDir");
if(sysPath != NULL)
{
  sysPath = sysPath + "\Outlook Express\msoe.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath);
  sysVer = GetVer(file:file, share:share);

  if(sysVer != NULL)
  {
    # Windows 2K
    if(hotfix_check_sp(win2k:5) > 0)
    {
      # Grep for msoe.ll version < 5.50.5003.1000 and 6.0.2800.1983
      if(version_in_range(version:sysVer, test_version:"5.5", test_version2:"5.50.5003.999")||
         version_in_range(version:sysVer, test_version:"6.0", test_version2:"6.0.2800.1982")){
        security_hole(0);
      }
      exit(0);
    }
    # Windows XP
    if(hotfix_check_sp(xp:4) > 0)
    {
      SP = get_kb_item("SMB/WinXP/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for msoe.dll < 6.0.2900.3598
        if(version_is_less(version:sysVer, test_version:"6.0.2900.3598")){
          security_hole(0);
        }
        exit(0);
      }
      if("Service Pack 3" >< SP)
      {
        # Grep for msoe.dll < 6.0.2900.5843
        if(version_is_less(version:sysVer, test_version:"6.0.2900.5843")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
    # Windows 2003
    if(hotfix_check_sp(win2003:3) > 0)
    {
      SP = get_kb_item("SMB/Win2003/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for msoe.dll version < 6.0.3790.4548
        if(version_is_less(version:sysVer, test_version:"6.0.3790.4548")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
  }
}

# For DHTML Editing Component ActiveX Control
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                          item:"ProgramFilesDir");
if(sysPath != NULL)
{
  sysPath = sysPath + "\Common Files\Microsoft Shared\Triedit\Dhtmled.ocx";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysPath);
  sysVer = GetVer(file:file, share:share);

  if(sysVer != NULL)
  {
    # Windows 2K
    if(hotfix_check_sp(win2k:5) > 0)
    {
      # Grep for Dhtmled.ocx version < 6.1.0.9234
      if(version_is_less(version:sysVer, test_version:"6.1.0.9234")){
        security_hole(0);
      }
      exit(0);
    }
    # Windows XP
    if(hotfix_check_sp(xp:4) > 0)
    {
      SP = get_kb_item("SMB/WinXP/ServicePack");
      if(("Service Pack 2" >< SP) || ("Service Pack 3" >< SP))
      {
        # Grep for Dhtmled.ocx < 6.1.0.9247
        if(version_is_less(version:sysVer, test_version:"6.1.0.9247")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
    # Windows 2003
    if(hotfix_check_sp(win2003:3) > 0)
    {
      SP = get_kb_item("SMB/Win2003/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for Localspl.dll version < 6.1.0.9247
        if(version_is_less(version:sysVer, test_version:"6.1.0.9247")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
  }
}

# For Microsoft MSWebDVD ActiveX Control
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(sysPath != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                       string:sysPath + "\Mswebdvd.dll");
  sysVer = GetVer(file:file, share:share);

  if(sysVer != NULL)
  {
    # Windows XP
    if(hotfix_check_sp(xp:4) > 0)
    {
      SP = get_kb_item("SMB/WinXP/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for Mswebdvd.dll < 6.5.2600.3603
        if(version_is_less(version:sysVer, test_version:"6.5.2600.3603")){
          security_hole(0);
        }
        exit(0);
      }
      if("Service Pack 3" >< SP)
      {
        # Grep for Mswebdvd.dll < 6.5.2600.5848
        if(version_is_less(version:sysVer, test_version:"6.5.2600.5848")){
           security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
    # Windows 2003
    if(hotfix_check_sp(win2003:3) > 0)
    {
      SP = get_kb_item("SMB/Win2003/ServicePack");
      if("Service Pack 2" >< SP)
      {
        # Grep for Mswebdvd.dll version < 6.5.3790.4564
        if(version_is_less(version:sysVer, test_version:"6.5.3790.4564")){
          security_hole(0);
        }
        exit(0);
      }
      security_hole(0);
    }
  }
}
