###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-038.nasl 3928 2009-08-12 09:26:42Z aug $
#
# Microsoft Windows AVI Media File Parsing Vulnerabilities (971557)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900907);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1545", "CVE-2009-1546");
  script_bugtraq_id(35967, 35970);
  script_name("Microsoft Windows AVI Media File Parsing Vulnerabilities (971557)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-038.

  Vulnerability Insight:
  This vulnerability arises due to flaws in the way Microsoft Windows handles
  Audio Video Interleave (AVI) files.

  Impact:
  Attackers can exploit this issue via maliciously crafted AVI files to cause
  integer overflow, execute arbitrary code with the privileges of the affected
  user and may cause denial of service.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-038.mspx

  References:
  http://support.microsoft.com/kb/971557
  http://www.microsoft.com/technet/security/Bulletin/MS09-038.mspx

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-038 Hotfix (971557)
if(hotfix_missing(name:"971557") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath +
                                                         "\avifil32.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for avifil32.dll version 5.0 < 5.0.2195.7316
  if(version_in_range(version:dllVer, test_version:"5.0",
                      test_version2:"5.0.2195.7315")){
    security_hole(0);
  }
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for avifil32.dll version 5.1 < 5.1.2600.3585
    if(version_in_range(version:dllVer, test_version:"5.1",
                        test_version2:"5.1.2600.3584")){
      security_hole(0);
    }
    exit(0);
  }

  else if("Service Pack 3" >< SP)
  {
    # Check for avifil32.dll version 5.1 < 5.1.2600.5827
    if(version_in_range(version:dllVer, test_version:"5.1",
                        test_version2:"5.1.2600.5826")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for avifil32.dll version 5.2 < 5.2.3790.4527
    if(version_in_range(version:dllVer, test_version:"5.2",
                        test_version2:"5.2.3790.4526")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
