###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-055.nasl 5262 2009-10-14 18:55:09Z oct $
#
# Microsoft Windows ATL COM Initialization Code Execution Vulnerability (973525)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900880);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2493");
  script_bugtraq_id(35828);
  script_name("Microsoft Windows ATL COM Initialization Code Execution Vulnerability (973525)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-055.

  Vulnerability Insight:
  Errors in the ATL headers that handle instantiation of an object from data
  streams, which could allow attackers to instantiate arbitrary objects in
  Internet Explorer that can bypass certain related security policies.

  Impact:
  Successful exploitation will let the remote attackers execute arbitrary code,
  and can compromise a vulnerable system.

  Impact Level: System.

  Affected Software/OS:
  Microsoft Windows 2K SP4/XP SP3/2K3 SP2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-055.mspx

  Workaround:
  Set the killbit for the following CLSIDs,
  {0002E531-0000-0000-C000-000000000046}, {4C85388F-1500-11D1-A0DF-00C04FC9E20F}
  {0002E532-0000-0000-C000-000000000046}, {0002E554-0000-0000-C000-000000000046}
  {0002E55C-0000-0000-C000-000000000046}, {279D6C9A-652E-4833-BEFC-312CA8887857}
  {B1F78FEF-3DB7-4C56-AF2B-5DCCC7C42331}, {C832BE8F-4B89-4579-A217-DB92E7A27915}
  {A9A7297E-969C-43F1-A1EF-51EBEA36F850}, {DD8C2179-1B4A-4951-B432-5DE3D1507142}
  {4F1E5B1A-2A80-42ca-8532-2D05CB959537}, {27A3D328-D206-4106-8D33-1AA39B13394B}
  {DB640C86-731C-484A-AAAF-750656C9187D}, {15721a53-8448-4731-8bfc-ed11e128e444}
  {3267123E-530D-4E73-9DA7-79F01D86A89F}
  http://www.microsoft.com/technet/security/advisory/972890.mspx

  References:
  http://support.microsoft.com/kb/973525
  http://www.vupen.com/english/advisories/2009/2890
  http://www.microsoft.com/technet/security/bulletin/MS09-055.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the CLSID and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");


function is_killbit_set(clsid)
{
  if(clsid)
  {
    activeKey = "SOFTWARE\Microsoft\Internet Explorer\" +
                "ActiveX Compatibility\" + clsid;
    killBit = registry_get_dword(key:activeKey, item:"Compatibility Flags");
    if(killBit && (int(killBit) == 1024)){
      return 1;
    }
    return 0;
  }
  return -1;
}


if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# MS09-055 Hotfix check
if(hotfix_missing(name:"973525") == 0){
  exit(0);
}

# Check if Kill-Bit is set for ActiveX control
clsids = make_list(
  "{0002E531-0000-0000-C000-000000000046}", "{4C85388F-1500-11D1-A0DF-00C04FC9E20F}",
  "{0002E532-0000-0000-C000-000000000046}", "{0002E554-0000-0000-C000-000000000046}",
  "{0002E55C-0000-0000-C000-000000000046}", "{279D6C9A-652E-4833-BEFC-312CA8887857}",
  "{B1F78FEF-3DB7-4C56-AF2B-5DCCC7C42331}", "{C832BE8F-4B89-4579-A217-DB92E7A27915}",
  "{A9A7297E-969C-43F1-A1EF-51EBEA36F850}", "{DD8C2179-1B4A-4951-B432-5DE3D1507142}",
  "{4F1E5B1A-2A80-42ca-8532-2D05CB959537}", "{27A3D328-D206-4106-8D33-1AA39B13394B}",
  "{DB640C86-731C-484A-AAAF-750656C9187D}", "{15721a53-8448-4731-8bfc-ed11e128e444}",
  "{3267123E-530D-4E73-9DA7-79F01D86A89F}");

foreach clsid (clsids)
{
  if(is_killbit_set(clsid:clsid) != 1)
  {
    security_hole(0);
    exit(0);
  }
}
