###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms10-002.nasl 6923 2010-10-22 10:11:42Z Jan $
#
# Microsoft Internet Explorer Multiple Vulnerabilities (978207)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901097);
  script_version("$Revision: 6492 $: 1.0");
  script_cve_id("CVE-2009-4074", "CVE-2010-0027", "CVE-2010-0244", "CVE-2010-0245",
                "CVE-2010-0246", "CVE-2010-0247", "CVE-2010-0248", "CVE-2010-0249");
  script_bugtraq_id(37883, 37135, 37884, 37891, 37895, 37892, 37893, 37894, 37815);
  script_name("Microsoft Internet Explorer Multiple Vulnerabilities (978207)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS10-002.

  Vulnerability Insight:
  The Multiple flaws are due to:
  - Use-after-free error in the 'mshtml.dll' library
  - Input validation error when processing URLs, which could allow a
    malicious web site to execute a binary from the local client system
  - Memory corruption error when the browser accesses certain objects,
    which could be exploited by remote attackers to execute arbitrary code
  - Browser disabling an HTML attribute in appropriately filtered response
    data, which could be exploited to execute script in the context of the
    logged-on user in a different Internet domain.
  - Error when the browser attempts to access incorrectly initialized
    memory which could be exploited by remote attackers to execute arbitrary
    code.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes via
  specially crafted HTML page in the context of the affected system and cause
  memory corruption.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Internet Explorer version 5.x/6.x/7.x/8.x

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS10-002.mspx

  References:
  http://www.vupen.com/english/advisories/2010/0187
  http://www.microsoft.com/technet/security/Bulletin/MS10-002.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable mshtml.dll file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# MS10-002 Hotfix (978207)
if(hotfix_missing(name:"978207") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for mshtml.dll version < 5.0.3884.1600 or 6.0 < 6.0.2800.1644
  if(version_in_range(version:vers, test_version:"5.0", test_version2:"5.0.3884.1599") ||
     version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2800.1643")){
    security_hole(0);
  }
}
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.3660
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2900.3659")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for mshtml.dll version 6.0.2900.5921, 7 < 7.0.6000.16981 , 8.0 < 8.0.6001.18876
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2900.5920")||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16980") ||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18875")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.3790.4639 , 7.0 < 7.0.6000.16981,
    # 8.0 <  8.0.6001.18876
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.3790.4638") ||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16980") ||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18875")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
