###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms10-003.nasl 7181 2010-02-10 10:10:09Z feb $
#
# Microsoft Office (MSO) Remote Code Execution Vulnerability (978214)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900228);
  script_version("$Revision: 6706 $: 1.0");
  script_cve_id("CVE-2010-0243");
  script_name("Microsoft Office (MSO) Remote Code Execution Vulnerability (978214)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS10-003.

  Vulnerability Insight:
  An unspecified issue exists in Mso.dll while handling specially crafted
  office files causing remote code execution.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code.

  Impact Level: System

  Affected Software/OS:
  Microsoft Office XP 3 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/MS10-003.mspx

  References:
  http://support.microsoft.com/kb/977896
  http://www.vupen.com/english/advisories/2010/0336
  http://www.microsoft.com/technet/security/bulletin/MS10-003.mspx

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Mso.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_office_products_version_900032.nasl",
                      "secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

## Get File Version
function FileVer (file, path)
{
  share = ereg_replace(pattern:"([A-Za-z]):.*", replace:"\1$", string:path);
  if(share =~ "[a-z]\$")
    share = toupper(share);
  file = ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:path + file);
  ver = GetVer(file:file, share:share);
  return ver;
}

## Office XP
if(get_kb_item("MS/Office/Ver") =~ "^10\..*")
{
  ## Get Office File Path
  offPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                            item:"CommonFilesDir");
  if(offPath)
  {
    offPath += "\Microsoft Shared\OFFICE10";
    dllVer = FileVer(file:"\Mso.dll", path:offPath);
    if(dllVer)
    {
      # Grep for Mso.dll version 10.0 < 10.0.6858.0
      if(version_in_range(version:dllVer, test_version:"10.0", test_version2:"10.0.6857.9"))
      {
        security_hole(0);
        exit(0);
      }
    }
  }
}
