###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms10-012.nasl 7184 2010-02-10 15:00:09Z feb $
#
# Microsoft Windows SMB Server Multiple Vulnerabilities (971468)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900230);
  script_version("$Revision: 6706 $: 1.0");
  script_cve_id("CVE-2010-0020", "CVE-2010-0021",
                "CVE-2010-0022", "CVE-2010-0231");
  script_name("Microsoft Windows SMB Server Multiple Vulnerabilities (971468)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS10-012.

  Vulnerability Insight:
  - An input validation error exists while processing SMB requests and can
    be exploited to cause a buffer overflow via a specially crafted SMB packet.
  - An error exists in the SMB implementation while parsing SMB packets during
    the Negotiate phase causing memory corruption via a specially crafted SMB
    packet.
  - NULL pointer dereference error exists in SMB while verifying the 'share'
    and 'servername' fields in SMB packets causing denial of service.
  - A lack of cryptographic entropy when the SMB server generates challenges
    during SMB NTLM authentication and can be exploited to bypass the
    authentication mechanism.

  Impact:
  Successful exploitation will let the remote attackers to execute arbitrary
  code or cause a denial of service or bypass the authentication mechanism
  via brute force technique.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2K3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms10-012.mspx

  References:
  http://secunia.com/advisories/38510/
  http://support.microsoft.com/kb/971468
  http://www.vupen.com/english/advisories/2010/0345
  http://www.microsoft.com/technet/security/bulletin/ms10-012.mspx

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Srv.sys file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

## Check Hotfix MS10-012
if(hotfix_missing(name:"971468") == 0){
  exit(0);
}

## Get System Path
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\drivers\Srv.sys");

## Get File Version
sysVer = GetVer(file:file, share:share);

if(!sysVer){
  exit(0);
}

## Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  ## Grep for Srv.sys version < 5.0.2195.7365
  if(version_is_less(version:sysVer, test_version:"5.0.2195.7365")){
    security_hole(0);
  }
  exit(0);
}

## Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    ## Grep for Srv.sys < 5.1.2600.3662
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3662")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    ## Grep for Srv.sys < 5.1.2600.5923
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5923")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

## Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    ## Grep for Srv.sys version < 5.2.3790.4634
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4634")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
