##############################################################################
#
#  Microsoft Access Snapshot Viewer ActiveX Control Vulnerability
#
#  Date Written: 2008/07/08
#
#  Revision: 1.5
#
#  Log: 
#  Issue #0013 (By schandan).
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900004);
 script_bugtraq_id(30114);
 script_cve_id("CVE-2008-2463");
 script_copyright("Copyright 2008 SecPod");
 script_version ("Revision: 1.5 ");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_name("Microsoft Access Snapshot Viewer ActiveX Control Vulnerability");
 script_summary("Check for Microsoft Access Snapshot Viewer Version");
 desc = "
 MS08-041

 Overview : Microsoft Access Snapshot in Microsoft Office Access is prone
 to ActiveX control vulnerabilities.

 Vulnerability Insight:

        Overview : Microsoft Access Snapshot in Microsoft Office Access is prone
        to ActiveX control vulnerabilities.

        The ActiveX control for viewing a snapshot of Microsoft Access report. 
        A specially crafted Web site, when visited can inject arbitrary code
        because of a vulnerability in the ActiveX control.

        Impact : Exploitation involves convincing the victim to view an HTML 
        document (eg., web page, HTML email, or email attachment). When a 
        user views the web page, the vulnerability could allow remove code
        execution.  

 Impact Level : System

 Affected Software/OS:
 MS Access Snapshot (with/without) MS Office Access (2000/2002/2003) - Windows (All).

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-041.mspx

 References :
 http://www.kb.cert.org/vuls/id/837785
 http://support.microsoft.com/kb/240797
 http://www.frsirt.com/english/advisories/2008/2012
 http://www.microsoft.com/technet/security/advisory/955179.mspx
 http://www.microsoft.com/technet/security/bulletin/ms08-041.mspx


 CVSS Score Report :
        CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 6.0 
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
			     "\Uninstall\Snapshot Viewer")){
	exit(0);
 }

 ocxFile = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
			   item:"Install Path");
 ocxFile += "\snapview.ocx";

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ocxFile);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ocxFile);

 name 	=  kb_smb_name();
 login	=  kb_smb_login();
 pass  	=  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
	exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
	exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
	exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
		       domain:domain, prot:prot);
 if(!r){
	exit(0);
 }

 uid = session_extract_uid(reply:r);
 
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
 tid = tconx_extract_tid(reply:r);
 if(!tid){
	exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
	exit(0);
 }

 fsize = smb_get_file_size(socket:soc, uid:uid, tid:tid, fid:fid);
 off = fsize - 90000;

 while(fsize != off)
 {
	data = ReadAndX(socket:soc, uid:uid, tid:tid, count:16384, off:off);
	data = str_replace(find:raw_string(0), replace:"", string:data);
	version = strstr(data, "ProductVersion");
	if(!version){
		off += 16383;
	}	
	else break;
 }

 if(!version){
	exit(0);
 }

 v = "";
 for(i = strlen("ProductVersion"); i < strlen(version); i++)
 {
 	if((ord(version[i]) < ord("0") ||
    	    ord(version[i]) > ord("9")) && version[i] != "."){
		break;
 	}
 	else 
   		v += version[i];
 }

 # Grep < 11.0.8228.0
 if(egrep(pattern:"^10\.0\.([0-4][0-9].*|5[0-4].*|55[0-2][0-9])", string:v)){
	security_hole(0);
 }
