###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_dos_vuln_nov09.nasl 5793 2009-11-18 12:31:29Z nov $
#
# Microsoft Internet Denial Of Service Vulnerability - Nov09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900891);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3943");
  script_name("Microsoft Internet Denial Of Service Vulnerability - Nov09");
  desc = "
  Overview: This host is installed with Internet Explorer and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  An error exists when a JavaScript loop that configures the home page by using
  the 'setHomePage' method and a 'DHTML' behavior property. This can be exploited
  to cause a application hang.

  Impact:
  Successful attacks may result in Denial of Service condition on the affected
  application.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 6.0 to 6.0.2900.2180 and 7.0 to 7.0.6000.16711

  Fix:
  No solution or patch is available as on 18th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/internet-explorer/default.aspx

  References:
  http://websecurity.com.ua/3658/
  http://www.securityfocus.com/archive/1/archive/1/507731/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/EXE/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");


ieVer = get_kb_item("MS/IE/EXE/Ver");
if(!ieVer){
  exit(0);
}

if(version_in_range(version:ieVer,test_version:"6.0", test_version2:"6.0.2900.2180")||
   version_in_range(version:ieVer,test_version:"7.0", test_version2:"7.0.6000.16711")){
  security_warning(0);
}
