##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_iis_ftpd_detect.nasl 5261 2009-10-14 02:08:29Z oct $
#
# Microsoft IIS FTP Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900875);
  script_version("$Revision: 1.0 $");
  script_name("Microsoft IIS FTP Server Version Detection");
  desc = "
  Overview: This script detects the installed Microsoft IIS FTP Server version
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Microsoft IIS FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("FTP");
  script_dependencies("secpod_ftp_anonymous.nasl");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)) {
  exit(0);
}

banner = get_ftp_banner(port:ftpPort);
if("Microsoft FTP Service" >< banner)
{
  set_kb_item(name:"MS/IIS-FTP/Installed", value:TRUE);
  ver = eregmatch(pattern:"Microsoft FTP Service \(Version ([0-9.]+)\)",
                  string:banner);
  if(!isnull(ver[1])){
    set_kb_item(name:"MS/IIS-FTP/Ver", value:ver[1]);
  }
}
