###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_office_detection_900025.nasl 0021 2008-08-13 16:54:55Z aug $
#
# Microsoft Office Version Detection
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Regex pattern modified to match proper Office 2007.
#  - By Chandan S <schandan@secpod.com> On 2009-11-11 #5697
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900025);
  script_version("$Revision: 1.1 $");
  script_name("Microsoft Office Version Detection");
  desc = "
  Overview: This script will Detect Microsoft Office Version and sets the
  result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of Microsoft Office");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Office")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
if(entries == NULL){
  exit(0);
}

foreach item (entries)
{
  MSOffName = registry_get_sz(key:key + item, item:"DisplayName");
  if(egrep(pattern:"Microsoft Office.* Viewer", string:MSOffName))
  {
     MSOffVer = registry_get_sz(key:key + item, item:"DisplayVersion");
     if(MSOffVer){
       set_kb_item(name:"MS/Office/Viewer/Ver", value:MSOffVer);
     }
     continue;
  }

  if(egrep(pattern:"Microsoft Office (2000|XP|.* Edition 2003$|[^L)].* 2007$)",
           string:MSOffName))
  {
    MSOffVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(MSOffVer){
      set_kb_item(name:"MS/Office/Ver", value:MSOffVer);
    }
    continue;
  }
}
