###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_taskmgr_info_disc_vuln.nasl 918 2009-01-30 12:19:35Z jan $
#
# MS Windows taskmgr.exe Information Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900302);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0320");
  script_bugtraq_id(33440);
  script_name("MS Windows taskmgr.exe Information Disclosure Vulnerability");
  desc = "

  Overview: This host is running Windows Operating System and is prone to
  information disclosure vulnerability.

  Vulnerability Insight:
  The I/O activity measurement of all processes allow to obtain sensitive
  information by reading the I/O other bytes column in taskmgr.exe to
  estimate the number of characters that a different user entered at a
  password prompt through 'runas.exe'.

  Impact:
  Successful exploitation will let the attacker retrieve password related
  information and can cause brute force or benchmarking attacks.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows XP SP3 and prior.
  Microsoft Windows Server 2003 SP2 and prior.

  Fix: No solution or patch is available as on 03rd February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/en/us/default.aspx

  References:
  http://www.unifiedds.com/?p=44
  http://www.securityfocus.com/archive/1/archive/1/500393/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:L/AC:H/Au:NR/C:C/I:N/A:N)
    CVSS Temporal Score : 3.4
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the existence of Windows");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("secpod_reg.inc");

if(hotfix_check_sp(xp:4, win2003:3) > 0){
  security_warning(0);
}
