###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mutt_sec_bypass_vuln.nasl 2973 2009-06-23 15:05:27Z jun $
#
# Mutt Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900676);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1390");
  script_bugtraq_id(35288);
  script_name("Mutt Security Bypass Vulnerability");
  desc = "

  Overview: This host has installed Mutt and is prone to Security Bypass
  Vulnerability

  Vulnerability Insight:
  When Mutt is linked with OpenSSL or GnuTLS it allows connections
  only one TLS certificate in the chain instead of verifying the entire chain.

  Impact:
  Successful exploits allow attackers to spoof SSL certificates of trusted
  servers and redirect a user to a malicious web site.

  Impact Level: Application

  Affected Software/OS:
  Mutt version 1.5.19 on Linux.

  Fix:Apply the patch
  https://bugzilla.redhat.com/show_bug.cgi?id=504979

  References:
  http://xforce.iss.net/xforce/xfdb/51068
  http://www.openwall.com/lists/oss-security/2009/06/10/2

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.0
  Risk factor : Medium";

  script_description(desc);
  script_summary("Checks for the Version of Mutt");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_mutt_detect.nasl");
  script_require_keys("Mutt/Ver");
  exit(0);
}


include("version_func.inc");

muttVer = get_kb_item("Mutt/Ver");
if(muttVer != NULL)
{
  if(version_is_equal(version:muttVer, test_version:"1.5.19")){
    security_warning(0);
  }
}
