###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_netdecision_tftp_server_detect.nasl 2412 2009-05-21 21:07:05Z may $
#
# NetDecision TFTP Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900357);
  script_version ("$Revision: 1.0 $");
  script_name("NetDecision TFTP Server Version Detection");
  desc = "

  Overview: This script is detects installed version of NetDecision TFTP Server
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB of NetDecision TFTP Server Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}


if(!registry_key_exists(key:"SOFTWARE\NetDecision")){
  exit(0);
}

netdeciKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item(registry_enum_keys(key:netdeciKey))
{
  netdeciName = registry_get_sz(key:netdeciKey + item, item:"DisplayName");

  if("NetDecision" >< netdeciName)
  {
    netdeciPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                                  item:"ProgramFilesDir");
    if(netdeciPath != NULL)
    {
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:netdeciPath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                          string:netdeciPath + "\NetDecision\Bin\TFTPServer.exe");

      soc = open_sock_tcp(port);
      if(!soc){
        exit(0);
      }

      r = smb_session_request(soc:soc, remote:name);
      if(!r)
      {
        close(soc);
        exit(0);
      }

      prot = smb_neg_prot(soc:soc);
      if(!prot)
      {
        close(soc);
        exit(0);
      }

      r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                            prot:prot);
      if(!r)
      {
        close(soc);
        exit(0);
      }

      uid = session_extract_uid(reply:r);
      if(!uid)
      {
        close(soc);
        exit(0);
      }

      r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
      tid = tconx_extract_tid(reply:r);
      if(!tid){
        close(soc);
        exit(0);
      }

      fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
      if(!fid){
        close(soc);
        exit(0);
      }
    }

    netdeciVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr="prod");
    close(soc);

    if(netdeciVer){
      set_kb_item(name:"NetDecision/TFTP/Ver", value:netdeciVer);
    }
    exit(0);
  }
}
