###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_netdecision_tftp_server_dir_trav_vuln.nasl 2412 2009-05-21 20:30:29Z may $
#
# NetDecision TFTP Server Multiple Directory Traversal Vulnerabilities
#
# Authors:
# Sharath s <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900358);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1730");
  script_bugtraq_id(35002);
  script_name("NetDecision TFTP Server Multiple Directory Traversal Vulnerabilities");
  desc = "

  Overview: This host is running NetDecision TFTP Server and is prone to
  multiple directory traversal vulnerabilities.

  Vulnerability Insight:
  Due to an input validation error within the TFTP server which in fails
  to sanitize user-supplied input in GET or PUT command via ../ (dot dot)
  sequences.

  Impact:
  Successful exploitation will let the attackers to disclose sensitive
  information,upload or download files to and from arbitrary locations.
  and compromise a vulnerable system to legitimate users.


  Affected Software/OS:
  NetMechanica, NetDecision TFTP Server version 4.2 and prior

  Fix: No solution or patch is available as on 29th May, 2009. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.netmechanica.com

  References:
  http://secunia.com/advisories/35131
  http://xforce.iss.net/xforce/xfdb/50574
  http://www.securityfocus.com/archive/1/503605

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.5
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of NetDecision TFTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("find_service.nes",
                      "secpod_netdecision_tftp_server_detect.nasl");
  script_require_keys("Services/udp/tftp", "NetDecision/TFTP/Ver");
  exit(0);
}


include("version_func.inc");


netdeciPort = get_kb_item("Services/udp/tftp");
if(!netdeciPort){
  netdeciPort = 69;
}

if(!get_udp_port_state(netdeciPort)){
  exit(0);
}

netdeciVer = get_kb_item("NetDecision/TFTP/Ver");
if(netdeciVer != NULL)
{
  if(version_is_less_equal(version:netdeciVer, test_version:"4.2")){
    security_warning(netdeciPort, proto:"udp");
  }
}
