###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_novell_iprint_client_actvx_bof_vuln.nasl 4730 2009-09-15 15:26:24Z sep $
#
# Novell iPrint Client ActiveX Control Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900852);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3176");
  script_bugtraq_id(36231);
  script_name("Novell iPrint Client ActiveX Control Buffer Overflow Vulnerability");
  desc = "
  Overview: This host has Novell iPrint Client installed and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an unspecified buffer-overflow errors, because the
  application fails to perform boundary checks on user-supplied data.

  Impact:
  Successful exploits allow remote attackers to execute arbitrary code in the
  context of the application using the ActiveX control (typically Internet
  Explorer). Failed exploit attempts will likely result in denial-of-service
  conditions.

  Impact Level: System/Application

  Affected Software/OS:
  Novell iPrint Client version 4.38 and prior on Windows.

  Fix:
  No solution or patch is available as on 16th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://download.novell.com/index.jsp

  References:
  http://intevydis.com/vd-list.shtml
  http://secunia.com/advisories/36579/

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Novell iPrint Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")) {
  exit(0);
}

# Grep the Novell iPrint Client version from Registry
ver = registry_get_sz(key:"SOFTWARE\Novell-iPrint", item:"Current Version");
if(!ver) {
  exit(0);
}

iprintVer = eregmatch(pattern:"v([0-9.]+)", string:ver);
if(iprintVer[1] != NULL)
{
  # Check for Novell iPrint Client version < 4.38
  if(version_is_less_equal(version:iprintVer[1], test_version:"4.38")){
    security_hole(0);
  }
}
