###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_novell_iprint_client_mult_bof_vuln_win.nasl 6124 2009-12-18 18:20:51Z dec $
#
# Novell iPrint Client Multiple BOF Vulnerabilities (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900729);
  script_version("$Revision: 6233 $: 1.0");
  script_cve_id("CVE-2009-1569", "CVE-2009-1568");
  script_bugtraq_id(37242);
  script_name("Novell iPrint Client Multiple BOF Vulnerabilities (Win)");
  desc = "
  Overview: This host is running Novell iPrint Client and is prone to multiple
  Buffer Overflow vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are caused due to inadequate boundary checks on user supplied
  inputs while the application processes the input data into the application
  context.

  Impact:
  Successful exploitation lets the remote attacker have a control over the remote
  system registers allowing execution of malformed shellcode.

  Impact Level: System

  Affected Software/OS:
  Novell iPrint Client version prior to 5.32

  Fix:
  Upgrade Novell iPrint Client version to 5.32
  http://download.novell.com

  References:
  http://secunia.com/advisories/37169
  http://secunia.com/secunia_research/2009-40/
  http://www.vupen.com/english/advisories/2009/3429
  http://download.novell.com/Download?buildid=29T3EFRky18~
  http://www.securityfocus.com/archive/1/archive/1/508288/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Novell iPrint Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_novell_prdts_detect_win.nasl");
  script_require_keys("Novell/Client/Ver");
  exit(0);
}


include("version_func.inc");

iPrintVer =  get_kb_item("Novell/iPrint/Ver");
if(!iPrintVer){
  exit(0);
}

if(version_is_less(version:iPrintVer, test_version:"5.32")){
  security_hole(0);
}
