##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_novell_prdts_detect_lin.nasl 3517 2009-07-22 16:39:37Z jul $
#
# Novell Products Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Updated :
# Novell iPrint Client Detection
# Sujit Ghosal <sghosal@secpod.com>  on 2009-12-18 #6124
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900598);
  script_version("$Revision: 6683 $: 1.2");
  script_name("Novell Products Version Detection (Linux)");
  desc = "

  Overview : This script retrieves the installed version of Novell
  products and saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set Version of Novell Products in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

#Set Version KB for Novell eDir Client
eDirPath = find_bin(prog_name:"ndsd", sock:sock);
foreach eDirFile (eDirPath)
{
  eDirVer = get_bin_version(full_prog_name:chomp(eDirFile), version_argv:"--version",
                   ver_pattern:"Novell eDirectory ([0-9.]+).?(SP[0-9]+)?", sock:sock);


  if(!isnull(eDirVer[1])) {
  
    if(eDirVer[2] != NULL){
        eDirVer = eDirVer[1] + "." + eDirVer[2];
    }
    else
      eDirVer = eDirVer[1];

    set_kb_item(name:"Novell/eDir/Lin/Ver", value:eDirVer);

  }  
}

#Set Version KB for Novell iPrint Client
iPrintPaths = find_file(file_name:"iprntcmd", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach iPrintBin (iPrintPaths)
{
  iPrintVer = get_bin_version(full_prog_name:chomp(iPrintBin), sock:sock,
                              version_argv:"-v", ver_pattern:" v([0-9.]+)");
  if(iPrintVer[1] != NULL) {
    set_kb_item(name:"Novell/iPrint/Client/Linux/Ver", value:iPrintVer[1]);
  }
}
ssh_close_connection();

