###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_novell_prdts_detect_win.nasl 1874 2009-04-23 12:57:24Z apr $
#
# Novell Multiple Products Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Modified by: Nikita MR (rnikita@secpod.com)
# Date: 24th July 2009
# Changes: Modified the kb name to indicate windows version.
#
# Modified by: Nikita MR (rnikita@secpod.com)
# Date: 09th Nov 2009
# Changes: Added check for Novell Groupwise client.
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900340);
  script_version("Revision: 1.2");
  script_name("Novell Multiple Products Version Detection");
  desc = "
  Overview : This script detects the installed version of Novell Products
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the Version of Novell Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Set KB for Novell eDirectory (NDSD)
if(registry_key_exists(key:"SOFTWARE\Novell\NDS"))
{
  eDirName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\Uninstall\NDSonNT", item:"DisplayName");
  if("eDirectory" >< eDirName)
  {
    eDirVer = eregmatch(pattern:"([0-9]\.[0-9.]+).?(SP[0-9])?", string:eDirName);
    if(eDirVer[1] != NULL && eDirVer[2] != NULL){
      eDirVer = eDirVer[1] + "." + eDirVer[2];
    }
    else{
      eDirVer = eDirVer[1];
    }
    if(eDirVer){
      set_kb_item(name:"Novell/eDir/Win/Ver", value:eDirVer);
    }
  }
}

# Set KB for Novell iPrint
if(registry_key_exists(key:"SOFTWARE\Novell-iPrint"))
{
  iprintVer = registry_get_sz(key:"SOFTWARE\Novell-iPrint",
                              item:"Current Version");
  if(!iprintVer)
  {
    iprintName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                    "\Uninstall\Novell iPrint Client",
                                item:"DisplayName");
    if("iPrint" >< iprintName)
    {
      iprintVer = eregmatch(pattern:"v([0-9.]+)", string:iprintName);
      if(iprintVer[1]){
        iprintVer = iprintVer[1];
      }
    }
  }

  if(iprintVer){
    set_kb_item(name:"Novell/iPrint/Ver", value:iprintVer);
  }
}

# Set KB for Novell Client
if(registry_key_exists(key:"SOFTWARE\Novell"))
{
  clientVer = registry_get_sz(key:"SOFTWARE\Novell\NetWareWorkstation" +
                                  "\CurrentVersion", item:"ProductName");
  if("Novell Client" >< clientVer)
  {
    clientVer = eregmatch(pattern:"([0-9]\.[0-9.]+).?(SP[0-9]+)?", string:clientVer);
    if(clientVer[1] != NULL && clientVer[2] != NULL){
      clientVer = clientVer[1] + "." + clientVer[2];
    }
    else if(clientVer[1] =~ "[0-9]+"){
      clientVer = clientVer[1];
    }
  }
  else{
    clientVer = registry_get_sz(key:"SOFTWARE\Novell", item:"CurrentVersion");
  }

  if(clientVer){
    set_kb_item(name:"Novell/Client/Ver", value:clientVer);
  }
}

# Set KB for Novell NetIdentity
if(registry_key_exists(key:"SOFTWARE\Novell\NetIdentity"))
{
  key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
  foreach item (registry_enum_keys(key:key))
  {
    netidName = registry_get_sz(key:key + item, item:"DisplayName");

    if("NetIdentity" >< netidName)
    {
      netidVer = eregmatch(pattern:"([0-9]\.[0-9.]+)", string:netidName);

      if(netidVer[1] != NULL)
      {
        set_kb_item(name:"Novell/NetIdentity/Ver", value:netidVer[1]);

        buildVer = registry_get_sz(key:key + item, item:"DisplayVersion");
        if(!buildVer)
        {
          buildVer = registry_get_sz(key:"SOFTWARE\Novell\NetIdentity",
                                     item:"Version");
        }
        if(buildVer){
          set_kb_item(name:"Novell/NetIdentity/Build/Ver", value:buildVer);
        }
      }
    }
  }
}

# Set kb for Novell Groupwise Client
if(registry_key_exists(key:"SOFTWARE\Novell\GroupWise"))
{
  gcPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"+
                               "\App Paths\GrpWise.exe", item:"Path");
  if(gcPath != NULL)
  {
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:gcPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)",  replace:"\1",  string:gcPath +
                                                             "\GrpWise.exe");
    gcVer = GetVer(file:file, share:share);
    if(gcVer != NULL){
      set_kb_item(name:"Novell/Groupwise/Client/Win/Ver", value:gcVer);
    }
  }
}
