##############################################################################
#
#  OpenSSH CBC Mode Information Disclosure Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/18
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0497
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900179);
  script_bugtraq_id(32319);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_name("OpenSSH CBC Mode Information Disclosure Vulnerability");
  script_summary("Check for vulnerable version of OpenSSH");
  desc = "

  Overview: The host is installed with OpenSSH and is prone to information
  disclosure vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the improper handling of errors within an SSH session
  encrypted with a block cipher algorithm in the Cipher-Block Chaining 'CBC' mode.

  Impact:
  Successful exploits will allow attackers to obtain four bytes of plaintext from
  an encrypted session.
  
  Impact Level: Application

  Affected Software/OS:
  - SSH Communications Security Tectia Client and Server version 6.0.4 and prior
  - SSH Communications Security Tectia ConnectSecure version 6.0.4 and prior
  - OpenSSH OpenSSH version 4.7p1 and prior

  Fix: Upgrade to higher version
  http://www.openssh.com/portable.html

  References:
  http://secunia.com/advisories/32760/
  http://www.cpni.gov.uk/Docs/Vulnerability_Advisory_SSH.txt

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:P/I:None/I:N/A:N) 
    CVSS Temporal Score : 3.0
  Risk factor: Medium";

  script_description(desc);
  script_dependencies("gather-package-list.nasl", "ssh_detect.nasl");
  script_require_keys("ssh/login/uname");
  script_require_ports("Services/ssh", 22);
  exit(0);
}


include("ssh_func.inc");

port = get_kb_item("Services/ssh");
if(!port){
  exit(0);
}
if("Linux" >!< get_kb_item("ssh/login/uname")){
  exit(0);
}

foreach item (get_kb_list("ssh/*/rpms"))
{
  openItem = egrep(pattern:"^openssh~([.0-9a-z]+)~.*$", string:item);
  if("openssh" >< openItem)
  {
    # Grep for versions 4.7p1 and prior
    if(ereg(pattern:"OpenSSH_([0-3](\..*)?|4\.[0-7](p[0-2])?)($|[^.0-9])",
      string:get_kb_item("SSH/banner/" + port))){
      security_warning(port);
      exit(0);
    }
  }
}
