###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_unserialize_dos_vuln.nasl 6415 2009-12-30 14:10:24Z dec $
#
# PHP 'unserialize()' Function Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900993);
  script_version("$Revision: 6289 $: 1.0");
  script_cve_id("CVE-2009-4418");
  script_name("PHP 'unserialize()' Function Denial of Service Vulnerability");
  desc = "
  Overview: The host is running PHP and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  An error in 'unserialize()' function while processing malformed user supplied
  data containing a long serialized string passed via the '__wakeup()' or
  '__destruct()' methods.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary PHP
  code and cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  PHP 5.3.0 and prior on all running platform.

  Fix:
  No solution or patch is available as on 30th December,2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://php.net/downloads.php

  References:
  http://www.security-database.com/detail.php?alert=CVE-2009-4418
  http://www.suspekt.org/downloads/POC2009-ShockingNewsInPHPExploitation.pdf

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Grep for php version <= 5.3.0
if(version_is_less_equal(version:phpVer, test_version:"5.3.0")){
  security_warning(phpPort);
}
