##############################################################################
#
#  phpMyAdmin Cross-Site Scripting Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/24
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0282
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900134);
 script_bugtraq_id(31327);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("phpMyAdmin Cross-Site Scripting Vulnerability");
 script_summary("Check for vulnerable version of phpMyAdmin");
 desc = "
 Overview : The host is running phpMyAdmin, which is prone to Cross-Site 
 Scripting Vulnerability.

 Vulnerability Insight :

        Error exists in the PMA_escapeJsString() function in js_escape.lib.php
        file, which fails to sufficiently sanitize user-supplied data.

        Impact : Execution of arbitrary HTML and script code will allow attackers
        to steal cookie-based authentication credentials and to launch other
        attacks.

 Impact Level : Application

 Affected Software/OS :
        phpMyAdmin versions prior to 2.11.9.2 on all platform
 
 Fix : Update to version 2.11.9.2
 http://www.phpmyadmin.net/home_page/downloads.php

 *****
 NOTE : Ignore this warning, if above mentioned Update is applied already.
 *****

 References :
 http://www.phpmyadmin.net/home_page/downloads.php?relnotes=1
 http://secunia.com/advisories/31974/
 http://www.phpmyadmin.net/home_page/security.php?issue=PMASA-2008-8

 CVSS Score :
        CVSS Base Score     : 7.9 (AV:N/AC:M/Au:SI/C:C/I:C/A:N)
        CVSS Temporal Score : 5.9
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
 exit(0);
}


 include("http_func.inc");
 
 if(egrep(pattern:"^2\.(([0-9]|10)(\..*)|11(\.[0-8](\..*)?|\.9(\.[01])))",
                  string:get_kb_item("www/" + port + "/phpMyAdmin"))){
        security_hole(port:port);
 }
