###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pidgin_detect_lin.nasl 2480 2009-06-01 15:21:24Z may $
#
# Pidgin Version Detection (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# Modified to detect multiple versions by using find_file().
#  - By Nikita MR <rnikita@secpod.com> On 2009-09-15 #4622
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900661);
  script_version("$Revision: 1.1 $");
  script_name("Pidgin Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of Pidgin and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock)
  exit(0);

paths = find_file(file_name:"pidgin", file_path:"/", useregex:TRUE,
                  regexpar:"$", sock:sock);

foreach pidginbin (paths)
{
  pidginVer = get_bin_version(full_prog_name:chomp(pidginbin), sock:sock,
                              version_argv:"--version",
                              ver_pattern:"Pidgin ([0-9.]+)");
  if(pidginVer[1] != NULL){
    set_kb_item(name:"Pidgin/Lin/Ver", value:pidginVer[1]);
  }
}
ssh_close_connection();
