###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pidgin_detect_win.nasl 2480 2009-06-01 17:47:29Z may$
#
# Pidgin Version Detection (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900662);
  script_version("$Revision: 1.0 $");
  script_name("Pidgin Version Detection (Win)");
  desc = "

  Overview: This script detects the installed version Pidgin and sets
  the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Pidgin\";
pidginName = registry_get_sz(key:key, item:"DisplayName");

if("Pidgin" >< pidginName)
{
  pidginVer = registry_get_sz(key:key, item:"DisplayVersion");
  if(pidginVer != NULL){
   set_kb_item(name:"Pidgin/Win/Ver", value:pidginVer);
  }
}
