###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pidgin_mul_bof_vuln_win.nasl 2480 2009-06-01 15:05:27Z may $
#
# Pidgin Multiple Buffer Overflow Vulnerabilities (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900664);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1373", "CVE-2009-1374",
                "CVE-2009-1375", "CVE-2009-1376");
  script_bugtraq_id(35067);
  script_name("Pidgin Multiple Buffer Overflow Vulnerabilities (Win)");
  desc = "

  Overview: This host has installed pidgin and is prone to Multiple Buffer
  Overflow Vulnerabilities

  Vulnerability Insight:
  The multiple flaws are due to,
  - a boundary error in the XMPP SOCKS5 'bytestream' server when initiating
    an outbound XMPP file transfer.
  - a boundary error in the 'decrypt_out()' function while processing
    malicious QQ packet.
  - a boundary error exists in the implementation of the 'PurpleCircBuffer'
    structure and can be exploited via vectors involving  XMPP or Sametime
    protocol.
  - a truncation error in  function 'libpurple/protocols/msn/slplink.c' and
   'libpurple/protocols/msnp9/slplink.c' when processing MSN SLP messages
    with a crafted offset value.

  Impact:
  Successful exploits allow attackers to run arbitrary code, corrupt memory
  and cause cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Pidgin version prior to 2.5.6 on Windows.

  Fix:Upgrade to version 2.5.6 or later.
  http://pidgin.im/download/

  References:
  http://secunia.com/advisories/35194
  http://secunia.com/advisories/35202
  http://xforce.iss.net/xforce/xfdb/50680
  http://rhn.redhat.com/errata/RHSA-2009-1059.html

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Checks for the Version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_pidgin_detect_win.nasl");
  script_require_keys("Pidgin/Win/Ver");
  exit(0);
}


include("version_func.inc");

pidginVer = get_kb_item("Pidgin/Win/Ver");
if(pidginVer != NULL)
{
  if(version_is_less(version:pidginVer, test_version:"2.5.6")){
    security_hole(0);
  }
}
