###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pivot_xss_vuln.nasl 3042 2009-06-25 22:06:33Z jun $
#
# Pivot Cross Site Scripting Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900579);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2133", "CVE-2009-2134");
  script_bugtraq_id(35363);
  script_name("Pivot Cross Site Scripting Vulnerability");
  desc = "

  Overview: This host is installed with Pivot and is prone to Cross Site
  Scripting vulnerability.

  Vulnerability Insight:
  - The input pased into several parameters in the pivot/index.php and
    pivot/user.php is not sanitised before being processed.
  - An error in pivot/tb.php while processing invalid url parameter reveals
    sensitive information such as the installation path in an error message.

  Impact:
  Successful exploitation will let the remote attackers to bypass security
  restrictions by gaining sensitive information, exectue arbitrary html or
  webscript code and redirect the user to other malicious sites.

  Impact Level: Application

  Affected Software/OS:
  Pivot version 1.40.7 and prior.

  Fix: No solution or patch is available as on 25th June, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.pivotlog.net/

  References:
  http://secunia.com/advisories/35363
  http://www.milw0rm.com/exploits/8941

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Pivot");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_pivot_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

pivotPort = get_http_port(default:80);
if(!pivotPort){
  exit(0);
}

pivotVer = get_kb_item("www/" + pivotPort + "/Pivot");
pivotVer = eregmatch(pattern:"^(.+) under (/.*)$", string:pivotVer);

if(pivotVer[2] != NULL)
{
  if(!safe_checks())
  {
    sndReq = http_get(item:string(pivotVer[2],'/pivot/index.php?menu=">'+
                      '<script>alert(123)</script><br'),port:pivotPort);
    rcvRes = http_send_recv(port:pivotPort, data:sndReq);
    if(("post" >< rcvRes) && ("<script>alert(123)</script>" >< rcvRes))
    {
      security_hole(pivotPort);
      exit(0);
    }
  }
}

if(pivotVer[1] == NULL){
  exit(0);
}

if(version_is_less_equal(version:pivotVer[1], test_version:"1.40.7")){
  security_hole(pivotPort);
}
