###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pplive_code_exe_vuln.nasl 1207 2009-03-31 13:50:24Z mar $
#
# PPLive Multiple Argument Injection Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900536);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1087");
  script_bugtraq_id(34128);
  script_name("PPLive Multiple Argument Injection Vulnerabilities");
  desc = "

  Overview: This host has PPLive installed and is prone to multiple argument
  injection vulnerabilities.

  Vulnerability Insight:
  Improper validation of user supplied input to the synacast://, Play://,
  pplsv://, and ppvod:// URI handlers via a UNC share pathname in the
  LoadModule argument leads to this injection attacks.

  Impact:
  By persuading a victim to click on a specially-crafted URI, attackers can
  execute arbitrary script code by loading malicious files(dll) through the
  UNC share pathname in the LoadModule argument.

  Impact Level: Application

  Affected Software/OS:
  PPLive version 1.9.21 and prior on Windows.

  Fix: No solution or patch is available as on 01st April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.pplive.com/en/index.html

  References:
  http://secunia.com/advisories/34327
  http://www.milw0rm.com/exploits/8215

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of PPLive");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_pplive_detect.nasl");
  script_require_keys("PPLive/Ver");
  exit(0);
}


include("version_func.inc");

ppliveVer = get_kb_item("PPLive/Ver");
if(!ppliveVer){
  exit(0);
}

# Check for PPLive version 1.9.21 and prior
if(version_is_less_equal(version:ppliveVer, test_version:"1.9.21")){
  security_hole(0);
}
