###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_realplayer_asm_ruleboook_bof_win.nasl 6968 2010-01-29 18:45:02Z jan $
#
# RealNetworks RealPlayer ASM RuleBook BOF Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902111);
  script_version("$Revision: 6608 $: 1.0");
  script_cve_id("CVE-2009-4247");
  script_bugtraq_id(37880);
  script_name("RealNetworks RealPlayer ASM RuleBook BOF Vulnerability (Win)");
  desc = "
  Overview: This host is installed with RealPlayer which is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The buffer overflow error occurs when processing a malformed 'ASM RuleBook'.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes within
  the context of the application and can cause heap overflow or cause remote
  code execution.

  Affected Software/OS:
  RealPlayer SP  1.0.0 and 1.0.1,
  RealPlayer versions befor 10.5(6.0.12.1741) and
  RealPlayer versions 11.0.0 through 11.0.4 on Windows platforms

  Fix:  Upgrade to RealPlayer version 10.5(6.0.12.1741) or 11.0.5 or 12.0.0.343
  For Updates Refer, http://www.real.com/player

  References:
  http://secunia.com/advisories/38218
  http://xforce.iss.net/xforce/xfdb/55794
  http://www.vupen.com/english/advisories/2010/0178
  http://service.real.com/realplayer/security/01192010_player/en/

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of RealPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_realplayer_detect_win.nasl");
  script_require_keys("RealPlayer/Win/Ver");
  exit(0);
}


include("version_func.inc");

rpVer = get_kb_item("RealPlayer/Win/Ver");
if(isnull(rpVer)){
  exit(0);
}

# Realplayer version 10.x(6.x) Realplayer version SP 1.x(12.0.0.x)
if(version_is_less(version:rpVer, test_version:"6.0.12.1741")||
   version_in_range(version:rpVer, test_version:"11.0.0", test_version2:"11.0.0.477") ||
   version_in_range(version:rpVer, test_version:"12.0.0", test_version2:"12.0.0.342")){
  security_hole(0);
}
