###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_silc_prdts_nickname_format_string_vuln.nasl 4736 2009-09-24 16:35:26Z sep $
#
# SILC Client Nickname Field Format String Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900951);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3051");
  script_bugtraq_id(35940);
  script_name("SILC Client Nickname Field Format String Vulnerability");
  desc = "
  Overview: This host has SILC Client/Toolkit installed, and is prone
  to Format String vulnerability.

  Vulnerability Insight:
  A format string error occurs in 'lib/silcclient/client_entry.c' while
  processing format string specifiers in the nickname field.

  Impact:
  Attackers can exploit this iisue to execute arbitrary code in the
  context of the affected application and compromise the system.

  Impact Level: Application/System

  Affected Software/OS:
  SILC Client prior to 1.1.8
  SILC Toolkit prior to 1.1.10.

  Fix: Apply the patch or upgrade to SILC Client 1.1.8.
  http://silcnet.org/
  http://www.securityfocus.com/bid/35940/solution

  *****
  NOTE: Please ignore this warning if the patch is already applied.
  *****

  References:
  http://secunia.com/advisories/36134
  http://www.vupen.com/english/advisories/2009/2150
  http://www.openwall.com/lists/oss-security/2009/09/03/5

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of SILC Client & Toolkit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_silc_prdts_detect.nasl");
  script_require_keys("SILC/Client/Ver", "SILC/Toolkit/Ver");
  exit(0);
}


include("version_func.inc");

# Check if the SILC-Client version is prior to 1.1.8
clntVer = get_kb_item("SILC/Client/Ver");
if(clntVer)
{
  if(version_is_less(version:clntVer, test_version:"1.1.8"))
  {
    security_hole(0);
    exit(0);
  }
}

