##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_subversion_detect.nasl 3867 2009-08-19 15:30:37Z aug $
#
# Subversion Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(101103);
  script_version("$ Revision:1.0 $");
  script_name("Subversion Version Detection");
  desc = "

  Overview : This script retrieves the version of Subversion
  and saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set Version of Subversion in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"svnversion", sock:sock);
foreach binaryFile (getPath)
{
   svnVer = get_bin_version(full_prog_name:chomp(binaryFile),
             version_argv:"--version", ver_pattern:"[0-9.]+", sock:sock);

   if(svnVer[0] != NULL){
      set_kb_item(name:"Subversion/Ver", value:svnVer[0]);
  }
}
ssh_close_connection();
