###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_surgemail_append_cmd_bof_vuln.nasl 4586 2009-09-14 10:38:17Z sep $
#
# SurgeMail 'APPEND' Command Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900840);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7182");
  script_bugtraq_id(30000);
  script_name("SurgeMail 'APPEND' Command Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is running SurgeMail and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  Buffer overflow in the IMAP service is caused due the way it handles the
  APPEND command which can be exploited via a long first argument.

  Impact:
  Successful exploitation could allow remote authenticated users to cause a
  Denial of Service and possibly execute arbitrary code in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  SurgeMail version prior to 3.9g2

  Fix: Upgrade to SurgeMail version 3.9g2 or later
  http://netwinsite.com/download.htm

  References:
  http://secunia.com/advisories/30739/
  http://www.milw0rm.com/exploits/5968
  http://www.securityfocus.com/archive/1/496482
  http://www.netwinsite.com/surgemail/help/updates.htm

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:N/I:N/A:P)
    CVSS Temporal Score : 3.1
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of SurgeMail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_surgemail_detect.nasl");
  script_require_keys("SurgeMail/Ver");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

# Grep for SurgeMail
surgemailVer = get_kb_item("SurgeMail/Ver");

if(!isnull(surgemailVer))
{
  # Check for SurgeMail version < 3.9g2
  if(version_is_less(version:surgemailVer, test_version:"3.9.g2")){
    security_warning(surgemail_port);
  }
}
