###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tor_detect_lin.nasl 625 2008-12-29 17:40:29Z dec $
#
# Tor Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) SecPod http://www.secpod.com
#
# Script Modified by Sharath S <sharaths@secpod.com> On 14th July 2009
# NOTE: Patterns and variables used previously were wrong.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900418);
  script_version("$Revision: 1.1 $");
  script_name("Tor Version Detection (Linux)");
  desc = "

  Overview: This script is detects the installed version of Tor and
  sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Check for Tor version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

tor_sock = ssh_login_or_reuse_connection();
if(!tor_sock){
  exit(0);
}

torName = find_file(file_name:"tor", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:tor_sock);

foreach binaryName (torName)
{
  binaryName = chomp(binaryName);
  torVer = get_bin_version(full_prog_name:binaryName, sock:tor_sock,
                           version_argv:"--version",
                           ver_pattern:"Tor v([0-9.]+-?([a-z0-9]+)?)");
  if(torVer[1] != NULL)
  {
    set_kb_item(name:"Tor/Linux/Ver", value:torVer[1]);
    ssh_close_connection();
  }
}
ssh_close_connection();
