##############################################################################
#
#  Trend Micro OfficeScan CGI Parsing Buffer Overflow Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/23
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0382
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900164);
  script_bugtraq_id(31859);
  script_cve_id("CVE-2008-3862");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Buffer overflow");
  script_name("Trend Micro OfficeScan CGI Parsing Buffer Overflow Vulnerability");
  script_summary("Check for vulnerable version of Trend Micro OfficeScan");
  desc = "
  Overview: This host is installed with Trend Micro OfficeScan and is prone to
  stack based buffer overflow vulnerability.

  The vulnerability is caused due to boundary error in the CGI modules when
  processing specially crafted HTTP request.

  Impact:
  Allows an attacker to execute arbitrary code, which may facilitate a complete
  compromise of vulnerable system.

  Impact Level: Application

  Affected Software/OS:
  TrendMicro OfficeScan Corporate Edition 7.3 Build prior to 1374.
  TrendMicro OfficeScan Corporate Edition 8.0 Build prior to 3110.

  Fix: Apply patch
  Apply patch Trend Micro OfficeScan Corporate Edition 8.0 from,
  http://www.trendmicro.com/ftp/products/patches/OSCE_8.0_SP1_Patch1_Win_EN_CriticalPatch_B3110.exe

  Apply patch Trend Micro OfficeScan Corporate Edition 7.3 from,
  http://www.trendmicro.com/ftp/products/patches/OSCE_7.3_Win_EN_CriticalPatch_B1374.exe
 
  *****
  NOTE: Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/32005/
  http://seclists.org/bugtraq/2008/Oct/0169.html
  http://www.trendmicro.com/ftp/documentation/readme/OSCE_7.3_CriticalPatch_B1374_readme.txt
  http://www.trendmicro.com/ftp/documentation/readme/OSCE_8.0_sp1p1_CriticalPatch_B3110_readme.txt
 
  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor : Medium";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\TrendMicro\NSC\PFW";
scanPath = registry_get_sz(key:key, item:"InstallPath");

if(!scanPath){
  exit(0);
}

scanPath += "PccNTMon.exe";

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:scanPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:scanPath);

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r){
  close(soc);
  exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot){
  close(soc);
  exit(0);
}

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                      prot:prot);
if(!r){
  close(soc);
  exit(0);
}

uid = session_extract_uid(reply:r);
if(!uid){
  close(soc);
  exit(0);
}

r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid){
  close(soc);
  exit(0);
}

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid){
  close(soc);
  exit(0);
}

fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid);

# Grep for OfficeScan prior to 8.0 build 3110 (SP1 Patch 1)
if(egrep(pattern:"^(8\.0(\.0(\.[0-2]?[0-9]?[0-9]?[0-9]|\.30[0-9][0-9]|\.310" +
                 "[0-9])?)?)$", string:fileVer)){
  security_warning(0);
}
